// Hello color shader is very simple shader which just dispaly pure color

float4x4 WvpXf : WorldViewProjection < string UIWidget="None"; >;

float4 k_d  
<
	string UIName = "pure color";
	string UIWidget = "Color";
> = float4( 1.0f, 1.0f, 1.0f, 1.0f );  


/* data from application vertex buffer */
struct appdata 
{
	float4 Position		: POSITION;
	float3 Normal		: NORMAL;
};

/* data passed from vertex shader to pixel shader */
struct vertexOutput 
{
    float4 HPosition	: SV_Position;
};
 
///////// VERTEX SHADING /////////////////////
vertexOutput std_VS(appdata IN) 
{
	vertexOutput OUT = (vertexOutput)0;
    OUT.HPosition = mul(IN.Position,WvpXf);
    return OUT;
}

///////// PIXEL SHADING //////////////////////
float4 std_PS(vertexOutput IN) : SV_Target 
{
    return k_d;
}

///// TECHNIQUES /////////////////////////////
technique11 T0
{
    pass P0
    {
        SetVertexShader(CompileShader(vs_5_0,std_VS()));
        SetGeometryShader( NULL );
		SetPixelShader(CompileShader(ps_5_0,std_PS()));
    }
}

/////////////////////////////////////// eof //
